使用手册
=======

本文将会详细讲解 Yu Writer 文档格式以及高级功能。

**注：本文仍在编写当中，其中部分内容非常陈旧，以后会逐步更新和完善。**

[[toc]]

# 文档格式控制

Yu Writer 的文档使用一种近似纯文本的 Markdown [^1] 格式来书写，本文档会以尽量简单的方式讲述 Markdown 格式的高级应用，而基础格式则可以阅读前一篇文章 [快速入门](quick-start)。如果在看完本文档仍然有疑问，可以参考 Markdown 规范的 [官方文档][Common Mark]。


## 列表

在一个段落开头添加一个 `*` 号和一个空格可以将该段落变成列表项，比如

* Item 1
* Item 2
* Item 3

也可以使用数字加一个 `.` 号将列表变成有序列表，比如

1. One
2. Two
3. Three

### 多段落列表项

如果某列表项由多个段落组成，第 2 个以及往后的段落需要在开头使用 2 个空格表示它从属于同一个列表项，比如

* Item 1
  Paragraph 1 in Item 1
  Paragraph 2 in Item 1
* Item 2
* Item 3

### 列表的嵌套

在列表内可以嵌套多级子列表，每一级子列表需要在段落开头多添加 2 个空格，比如

* Item 1
  * Item 1 in Sub List 1
  * Item 2 in Sub List 1
* Item 2
* Item 3

### 列表项的符号

除了使用 `*` 表示列表项，你还可以使用 `+` 号和 `-` 号，它们的作用都是相同的。

## 引用文字

如果需要在文档里添加引用文字（Blockquote），则在段落开头添加一个 `>` 号。比如

> Hello World!

## 代码块

如果需要在文档里添加一行（计算机语言）代码，则在开头添加 4 个空格。比如

    let i = 100;

如果有多行代码，则需要在每一行代码前面都添加 4 个空格。比如

    let i = 100;
    let j = 200;
    console.log(i + j);

代码块的内容在阅读模式或者导出 PDF 时，会自动以等宽字体（Monospace Font）显示。

### 围墙式代码块

你也可以使用 3 个连续的反单引号把一段文字包围起来表示代码块，这样可以避免每行代码开头都添加 4 个空格，比如

```
let i = 100;
let j = 200;
console.log(i + j);
```

### 语法加亮

使用围墙式代码块有个额外的功能：可以指定代码的语言种类（指计算机语言），让其中的代码的语法加亮，方法是在第一行反单引号后面写上语言种类的名称，比如

```javascript
let i = 100;
let j = 200;
console.log(i + j);
```

注：你需要在即时预览面板或者阅读模式下才能看到语法加亮的效果。

### 缩进

Yu Writer 支持快速修改代码块的缩进，方法是选择多行代码，然后按 `Tab` 键增加缩进，按 `Shift + Tab` 键减少缩进。

### 代码美化

点击工具栏上的 `Code` 按钮，然后输入代码，再点击 `Beautify Code` 可以对其中的代码进行美化，包括自动缩进、自动增加或删除空格等。

### 行内代码

如果只是想在一段文字里插入一行代码，可以把这行代码使用反单引号包括起来，如 `let i = 100`，本文当中的表示菜单、按钮、快捷键的地方都使用了该表示方法。

## 分隔符

（此部分仍在书写中）


## 链接

在文档中插入链接的格式是 `[Link Text](https://a.com)`，其中中括号里面的是链接的文字，括号里面的是链接地址。

在编辑状态下按下 `Command` 键（在 Windows 和 Linux 系统里对应的是 `Ctrl` 键）可以让链接变成可点击状态。

### 引用式链接

为了文档整洁，你可以把链接当中的地址部分抽取出来统一放到文档的末尾处，并使用中括号为链接地址命一个名称，比如 `[Link Name]: https://a.com/`。然后在文档当中的链接代码可以写成 `[Link Text][Link Name]`。其中 `[Link Text]` 部分可以直接省略，写成 `[Link Name]`，比如 [Common Mark]。

### 段落链接

Yu Writer 会自动为文档的每一个标题（Heading）自动生成一个链接锚，段落链接的格式是 `[Link Text](#heading-text)`，其中的 `#` 号表示此链接是一个段落链接。比如 [返回第一章](#文档格式控制) 

#### 标题文本的 Slugify 转换

一般标题文本可能会含有大小写、空格，有时还有标点符号，在书写段落链接代码时，需要先将标题文本进行 Slugify 转换，下面是转换的方法：

1. 所有拉丁字母转成相应的英文字母，比如 "Á" 转成 "A"；
2. 去掉所有标点符号，其中 `_`  号、空格符和`-` 号除外， 比如 "Hello! World." 转成 "Hello World"；
3. 所有`_`  号和空格转成 `-` 号，比如 "Hello World" 转成 "Hello-World"；
4. 所有大写转成小写，比如 "Hello-World" 转成 "hello-world"；
5. 多个连续的 `-` 号会合并成为一个，比如 "hello---world" 转成 "hello-world"。

举一个完整的列子，比如 "Introducing Create React Native App!" 应该转成 "introducing-create-react-native-app"。

#### 使用辅助工具插入段落链接

点击工具栏上的 `Link` 按钮，然后选择 `Link to Document or Section`，再选择你需要跳转到的段落，最后点击 `Insert` 按钮就可以插入正确的段落链接代码，此方法可避免手动转换段落文本。

### 文档链接

Yu Writer 支持文档链接，同一个文档库内的文档通过文档链接可以实现跳转。文档链接的格式是 `[Link Text](document-name)`，其中 `document-name` 是文档在文档库中的名字，当然文档名也需要进行跟标题文本相同的 Slugify 转换。比如 [The Quick Start Document](quick-start)。

如果目标文档位于子目录，则需要在文档名称前面添加子目录的名称和 `/` 号，比如 `sub-folder/sub-sub-folder/some-document`，如果目标文档位于父目录，则需要在文档名称前面添加 `../` ，有多少级父目录则重复多少次此前缀，比如上 2 级目录的某篇文档 `../../some-document` ，

文档链接和段落链接可以结合使用，比如 [Jump to Quick Start Section 1.2.2](quick-start#链接和图片)。


## 图片

插入图片的格式跟链接类似，如果链接地址是一个图片链接，则在链接代码的前面添加一个 `!` 符号让图片显示出来，比如 `![Image Text](https://a.com/b.jpg)`。

### 引用式图片

跟引用式链接类似，图片地址部分也是可以抽取出来统一放到文档的末尾处，比如 `[Image Name]: https://a.com/b.jpg`，然后文档中的图片代码可以写成 `![Image Text][Image Name]`。其中 `[Image Text]` 部分可以省略，直接写成 `![Image Name]`。

### 图片资源库

为方便管理文档的图片资源，Yu Writer 为每一个文档构建了一个独立的图片资源库（博客和电子书类型的文档库除外，它们是所有文档共用同一个图片资源库，下面有详细说明），点击工具栏的 `Image（图片）` 按钮将会显示一个图片资源库小窗口，在此可以管理当前文档的图片资源。

你可以把图片拖进这个小窗口中，选中图片然后点击 `Insert` 按钮就可以把相应的图片插入文档。

你可能会注意到从图片资源库插入的图片代码当中图片名称前面多了 `$res/` 这样的前缀，这个前缀是用于表示该图片是从文档的图片资源库中获取的。

Yu Writer 还有一个特殊的资源前缀 `$appres/`，这个表示该资源是从应用程序的共有资源库中获取的，这个前缀常见于文档模版中。

### 共用图片资源

Yu Writer 同时也兼容传统的目录结构资源，比如你可以把所有文档需要用到的图片都放进一个库内的文件夹里（比如一个叫做 `images` 的文件夹），这时你的图片格式应该是 `![Image Text](path-to-image)`，其中 `path-to-image` 是目标图片相对于你文档的相对路径。

### 图片的题注

如果图片代码写成单独一行，并且在前后各留一行空行，则代码中的 `[Image Text]` 会自动成为图片的题注。


## 表格

（此部分仍在书写中）


## 脚注

（此部分仍在书写中）


## 索引目录

（此部分仍在书写中）


# 文档、文档库以及同步

Yu Writer 内置了一个简便的文档库，用于管理和组织你的所有创作。你可以在文档库面板里管理你的所有文档库以及文档，如果你看不到左侧的文档库面板，请点击工具栏上的 `Library` 按钮。

## 新建文档

所有的文档必须在文档库里创建，如果你在文档库面板里返回到了最顶层，这里是不允许创建文档的，你需要双击其中一个文档库并进入后方能创建新文档。

应用程序默认会创建一个叫做 “Default” 的库，同时会附带一些演示文档（比如 “Welcome”、“Demo” 等），这些文档当你不需要时可以放心删除。

## 新建文档库

你可以创建多个文档库，用于管理不同性质的文档，比如作为日常笔记的一个库、作为写文章的一个库。新建文档库的方法是在文档库面板里返回到最顶层（通过点击面板左上角的返回按钮），然后点击菜单 `File` > `New Library` > `General Library` ，然后输入名字就完成了。

## iCloud Drive、OneDrive、Google Drive、Dropbox 等同步

你可以把位于你电脑里的 iCloud Drive、OneDrive、Google Drive、Dropbox 等文件夹添加进 Yu Writer 的文档库里，这样你就可以享用这些在线存储和同步服务来帮你同步文档库了。

添加方法是在文档库面板里返回到最顶层（通过点击面板左上角的返回按钮），然后点击菜单 `File` > `New Library` > `From External Folder...` ，然后选择你电脑上的 iCloud Drive、OneDrive、Google Drive、Dropbox 等里面的任一个文件夹就完成了。

## GitHub Pages、Jekyll、Hexo、Hugo 的支持

### 创建博客类型的文档库

在文档库面板里返回到最顶层，然后点击菜单 `File` > `New Library` > `From Blog...`，按照提示选取你的博客本地仓库的文件夹，再点确定即可。

### 排除编辑历史记录

因为 Yu Writer 也带有 “版本控制” 性质的文档历史记录功能，默认情况下你的所有本地的文档编辑历史记录也会一并推送到远程库，如果你的 GitHub Pages 或 Git 项目是多人协同编写的，则有可能出现历史记录冲突问题，或者你不想把本地的编辑历史记录也推送到远程库。可以编辑项目根目录之下的 `.gitignore` 文件，添加一行  `yulib.resource` 用于排除 Yu Writer 产生的资源。

## GitBook 的支持

（待补充）


# 用户界面

（待补充）

## 智能自动完成

（待补充）

## 大纲视图

（待补充）

## 即时预览

（待补充）

## 阅读模式

（待补充）

## 历史记录

（待补充）

## 手势操作

（待补充）

# Hack into Yu Writer

（待补充）

## 修改程序的默认配置文件

（待补充）

## 修改快捷键绑定

（待补充）

## 修改文档库的配置文件

（待补充）

[Common Mark]: http://commonmark.org/
[^1]: Common Mark http://commonmark.org/

* * *
返回 [目录](welcome)
